<?php
/*
 * Used for the search overlay
 *
 * @package WordPress
 * @subpackage Total
 * @since 1.1
*/


add_action( 'wp_footer', 'wpex_search_overlay' );

if ( ! function_exists('wpex_search_overlay') ) {
	
	function wpex_search_overlay() {
		
		// Do nothing if the main search is disabled
		if ( wpex_option( 'main_search', '1' ) !== '1' ) return;
		
		// Only show on certain header styles
		$header_style = wpex_option( 'header_style', 'one' );
		if ( $header_style == 'one' || $header_style == 'three' ) { ?>
	
			<section id="searchform-overlay" class="header-searchform-wrap clr">
				<div id="searchform-overlay-title"><?php _e('Search','wpex'); ?></div>
				<form method="get" action="<?php echo esc_url( home_url( '/' ) ); ?>" role="search" class="header-searchform">
					<input type="search" name="s" onfocus="if(this.value==this.defaultValue)this.value='';" onblur="if(this.value=='')this.value=this.defaultValue;" autocomplete="off" />
				</form>
			</section><!-- #searchform-overlay -->
		
		<?php	
		} // End header style check
				
	} // End function
	
} // End if