<?php
/**
 * Fixes spacing issues with shortcodes
 *
 * @package WordPress
 * @subpackage Total
 * @since Total 1.0
*/

if( !function_exists('vcex_fix_shortcodes') ) {
	function vcex_fix_shortcodes($content){   
		$array = array (
			'<p>['		=> '[', 
			']</p>'		=> ']', 
			']<br />'	=> ']'
		);
		$content = strtr($content, $array);
		return $content;
	}
}
add_filter('the_content', 'vcex_fix_shortcodes');


/**
 * Fixes spacing issues with shortcodes
 *
 * [wpml_translate lang=es]Hola[/wpml_translate]
 * [wpml_translate lang=en]Hello[/wpml_translate]
 *
 * @package WordPress
 * @subpackage Total
 * @since Total 1.21
*/
if(! function_exists('wpex_wpml_lang_translate')) {
	function wpex_wpml_lang_translate( $atts, $content = null ) {
		extract(shortcode_atts(array(
			'lang'	=> '',
		), $atts ) );
		$lang_active = ICL_LANGUAGE_CODE;
		if( $lang == $lang_active ) {
			return do_shortcode($content);
		}
	}
	add_shortcode('wpml_translate', 'wpex_wpml_lang_translate');
}