<?php
/**
 * Toggle Bar Output
 *
 * @package WordPress
 * @subpackage Total
 * @since Total 1.0
*/


// Check if the toggle bar is enabled
if ( ! function_exists( 'wpex_toggle_bar_active' ) ) {
	function wpex_toggle_bar_active() {
		if ( !wpex_option( 'toggle_bar' ) ) {
			return false;
		} elseif ( !wpex_option( 'toggle_bar_page' ) ) {
			return false;
		} elseif ( is_singular() && 'on' == get_post_meta( get_the_ID(), 'wpex_disable_toggle_bar', true ) ) {
			return false;
		} else {
			return true;
		}
	}
}


// The toggle bar main content
if ( ! function_exists( 'wpex_toggle_bar' ) ) {
	function wpex_toggle_bar() {
		// Toggle bar disabled or page not selected, lets bail!
		if ( !wpex_toggle_bar_active() ) return;
		// Get toggle bar page content
		$page = wpex_option( 'toggle_bar_page' );
		$content = get_post_field( 'post_content', $page ); ?>
		<div id="toggle-bar-wrap" class="clr <?php echo wpex_option( 'top_bar_visibility' ); ?>">
			<div id="toggle-bar" class="clr container">
				<div class="entry clr">
					<?php echo apply_filters( 'the_content', $content ); ?>
				</div><!-- .entry -->
			</div><!-- #toggle-bar -->
		</div><!-- #toggle-bar-wrap -->
	<?php
	} // End function
} // End if


// The Toggle Bar Button
if ( ! function_exists( 'wpex_toggle_bar_btn' ) ) {
	function wpex_toggle_bar_btn() {
		if ( !wpex_toggle_bar_active() ) return;
		echo '<a href="#" class="toggle-bar-btn fade-toggle"><span class="fa fa-plus"></span></a>';
	}
}