<?php
/**
 * Used to display related portfolio items
 *
 * @package WordPress
 * @subpackage Total
 * @since Total 1.1
*/


if ( ! function_exists( 'wpex_portfolio_single_media' ) ) {
	function wpex_portfolio_single_media() {
		if ( ! wpex_option( 'portfolio_single_media' ) ) return; ?>
		<div id="portfolio-single-media" class="clr">
			<?php
			// Post Video
			if ( wpex_get_portfolio_featured_video_url() ) {
				wpex_portfolio_post_video();
			}
			// Post Thumbnail
			elseif( has_post_thumbnail() ) { ?>
					<a href="<?php echo wpex_get_featured_image_url( $post_id = '', $attachment = '', $full_image = true ); ?>" title="<?php echo esc_attr( the_title_attribute( 'echo=0' ) ); ?>" class="wpex-lightbox">
						<img src="<?php echo wpex_get_featured_image_url( $post_id = '', $attachment = '', $full_image = false, $singular = true ); ?>" alt="<?php the_title(); ?>" class="portfolio-single-media-img" />
					</a>
			<?php } // End if ?>
		</div><!-- .portfolio-entry-media -->
	<?php } // End function
} // End if