<?php
/**
 * The Header for our theme.
 *
 * @package WordPress
 * @subpackage Total
 * @since Total 1.0
 */ ?>
<!DOCTYPE html>

<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>" />
	<?php wpex_meta_viewport(); ?>
	<title><?php wp_title( '|', true, 'right' ); ?><?php bloginfo('name'); ?></title>
	<link href='http://fonts.googleapis.com/css?family=Sanchez' rel='stylesheet' type='text/css'>
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
	<?php if ( wpex_option('custom_favicon') ) : ?>
		<link rel="shortcut icon" href="<?php echo wpex_option('custom_favicon'); ?>" />
	<?php endif; ?>
	<?php wp_head(); ?>


<!-- 
<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.2/css/bootstrap.min.css">
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.2/js/bootstrap.min.js"></script>
<style>
.dropdown-menu {
  position: inherit;
  top: 100%;
  left: 0;
  z-index: 1000;
  display: inherit;
  float: left;
  min-width: 160px;
  padding: 0px 0;
  margin: 0px 0 0;
  font-size: 14px;
  text-align: left;
  list-style: none;
  background-color: #fff;
  -webkit-background-clip: padding-box;
  background-clip: padding-box;
  border: 0px solid #ccc;
  border: 0px solid rgba(0,0,0,0);
  border-radius: 0px;
  -webkit-box-shadow: 0 6px 12px rgba(0,0,0,0);
  box-shadow: 0 6px 12px rgba(0,0,0,0);
}
.page-header {
  padding-bottom: 9px;
  margin: 0px 0 0px;
  border-bottom: 1px solid #eee;
}
.fa {

  margin-right: 0px;
}
</style> -->

</head>



<!-- flush comienzo -->
<?php flush(); ?>
<!-- flush fin -->



<!-- Begin Body -->
<body <?php body_class(); ?>>

	<?php
	// Before wrap hook
	wpex_hook_wrap_before(); ?>

	<div id="wrap" class="clr">

		<?php
		// Top wrap hook
		wpex_hook_wrap_top(); ?>
	
		<?php
		// Display header if enabled
		// See functions/header-display.php
		if ( wpex_display_header() == true ) {
			
			// Before header hook
			wpex_hook_header_before();

			/* This is a very unique and highly customizable header.
			 * All the content for your site header is added via hooks.
			 * Please have a look in functions/hooks/hooks-defaults.php to see the default
			 * functions that are addeed to the header.
			*/
			
			// Get header style for classnames
			$wpex_header_style = wpex_get_header_style(); ?>
			
			<header id="site-header" class="<?php wpex_header_classes(); ?>" role="banner">
				<?php wpex_hook_header_top(); ?>
				<div id="site-header-inner" class="container clr">
					<?php wpex_hook_header_inner(); ?>
				</div><!-- #site-header-inner -->
				<?php wpex_hook_header_bottom(); ?>


<div id="fb-root"></div>
<script>(function(d, s, id) {
  var js, fjs = d.getElementsByTagName(s)[0];
  if (d.getElementById(id)) return;
  js = d.createElement(s); js.id = id;
  js.src = "//connect.facebook.net/es_ES/sdk.js#xfbml=1&version=v2.3";
  fjs.parentNode.insertBefore(js, fjs);
}(document, 'script', 'facebook-jssdk'));</script>



			</header><!-- #header -->
			
			<?php
			// After header hook
			wpex_hook_header_after();
			
		} // end if header enabled check ?>
		
	<?php
	// Main before hook
	wpex_hook_main_before(); ?>
	
	<div id="main" class="site-main clr">
	
		<?php
		// Main top hook
		// Page Header & Page Slider functions are added here by default
		wpex_hook_main_top(); ?>

