<?php
/**
	Register Shortcode
**/
if( !function_exists('vcex_button_shortcode') ) {
	function vcex_button_shortcode( $atts, $content = null ) {
		extract( shortcode_atts( array(
			'layout'			=> '',
			'style'				=> 'graphical',
			'color'				=> 'blue',
			'url'				=> 'http://www.vcexplorer.com',
			'title'				=> __('Visit Site', 'vcex' ),
			'target'			=> 'self',
			'size'				=> 'normal',
			'font_weight'		=> '',
			'font_size'			=> '',
			'align'				=> 'alignleft',
			'rel'				=> '',
			'border_radius'		=> '',
			'class'				=> '',
			'icon_left'			=> '',
			'icon_right'		=> '',
			'css_animation'		=> '',
		), $atts ) );
		
		// Load required scripts
		if ( ( $icon_left && $icon_left !== 'none' ) || (  $icon_right && $icon_right !== 'none' ) ) {
			wp_enqueue_style('vcex_shortcode_font_awesome');
		}
		
		// Rel
		$rel = ( $rel !== 'none' ) ? 'rel="'.$rel.'"' : NULL;
		
		// Animation
		$css_animation_classes = '';
		if ( $css_animation !== '' ) {
			$css_animation_classes = 'wpb_animate_when_almost_visible wpb_'. $css_animation .'';
		}
		
		// Custom Style
		$inline_style = array();
		
		if ( $font_size ) {
			$inline_style[] = 'font-size: '. $font_size .';';
		}

		if ( $font_weight ) {
			$inline_style[] = 'font-weight: '. $font_weight .';';
		}
		
		if ( $border_radius ) {
			$inline_style[] = 'border-radius: '. $border_radius .';';
		}
		
		$inline_style = implode('', $inline_style);
		
		if ( $inline_style ) {
			$inline_style = wp_kses( $inline_style, array() );
			$inline_style = ' style="' . esc_attr($inline_style) . '"';
		}
		
		// Display Button
		$output= NULL;
		if ( $align == 'center' ) {
			$output.= '<div class="textcenter">';
		}
		$output.= '<a href="' . $url . '" class="vcex-button vcex-button-'. $layout .' '. $style .' align-'. $align .' '. $size .' ' . $color . ' '. $class .' '. $css_animation_classes .'" target="_'.$target.'" title="'. $title .'" '. $inline_style .' '. $rel .'>';
			$output.= '<span class="vcex-button-inner" '. $inline_style .'>';
				if ( $icon_left && $icon_left !== 'none' ) $output.= '<i class="vcex-button-icon-left fa fa-'. $icon_left .'"></i>';
				$output.= $content;
				if ( $icon_right && $icon_right !== 'none' ) $output.= '<i class="vcex-button-icon-right fa fa-'. $icon_right .'"></i>';
			$output.= '</span>';			
		$output.= '</a>';
		if ( $align == 'center' ) {
			$output.= '</div>';
		}
		return $output;
	}
}
add_shortcode('vcex_button', 'vcex_button_shortcode');



/**
	Extend Visual Composer
**/
vc_map( array(
	"name"					=> __( "Button", 'vcex' ),
	"description"			=> __( "Eye catching button", 'vcex' ),
	"base"					=> "vcex_button",
	"class"					=> "",
	'admin_enqueue_js'		=> "",
	'admin_enqueue_css'		=> "",
	"icon" 					=> "icon-wpb-vcex-button",
	"params"				=> array(
		array(
			"type"			=> "textfield",
			"heading"		=> __( "URL", 'vcex' ),
			"param_name"	=> "url",
			"value"			=> "http://www.google.com/",
			"description"	=> __( "Enter a target URL for your button. Don't forget the http:// at the front.", 'vcex' ),
		),
		array(
			"type"			=> "textfield",
			"heading"		=> __( "Button Text", 'vcex' ),
			"param_name"	=> "content",
			"admin_label"	=> true,
			"value"			=> "Button Text",
			"description"	=> __( "Your button Text.", 'vcex' ),
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __( "Link Title", 'vcex' ),
			"param_name"	=> "title",
			"value"			=> "Visit Site",
			"description"	=> __( "Your button link title attribute.", 'vcex' ),
		),
		array(
			"type"			=> "dropdown",
			"heading"		=> __("CSS Animation", "vcex"),
			"param_name"	=> "css_animation",
			"value"			=> array(
			__("No", "vcex")						=> '',
				__("Top to bottom", "vcex")			=> "top-to-bottom",
				__("Bottom to top", "vcex")			=> "bottom-to-top",
				__("Left to right", "vcex")			=> "left-to-right",
				__("Right to left", "vcex")			=> "right-to-left",
				__("Appear from center", "vcex")	=> "appear"),
			"description"	=> __("Select animation type if you want this element to be animated when it enters into the browsers viewport. Note: Works only in modern browsers.", "vcex")
		),
		array(
			"type"			=> "dropdown",
			"heading"		=> __( "Button Style", 'vcex' ),
			"param_name"	=> "style",
			"value"			=> array(
				__( "Graphical", "vcex")	=> "graphical",
				__( "Clean", "vcex")		=> "clean",
				__( "Flat", "vcex" )		=> "flat",
				__( "3D", "vcex" )			=> "three-d",
				__( "Outline", "vcex" )		=> "outline",
			),
			"description"	=> __( "Select a style for this button.", 'vcex' ),
		),
		array(
			"type"			=> "dropdown",
			"heading"		=> __("Layout", "vcex"),
			"param_name"	=> "layout",
			"value"			=> array(
				__("Default", "vcex") => '',
				__("Expanded (fit container)", "vcex") => "expanded",
			),
			"description"	=> __( "Select a layout style for this button.", 'vcex' ),
		),
		array(
			"type"			=> "dropdown",
			"class"			=> "",
			"heading"		=> __( "Button Align", 'vcex' ),
			"param_name"	=> "align",
			"value"			=> array(
				__( "Left", "vcex")		=> "left",
				__( "Right", "vcex")		=> "right",
				__( "Center", "vcex" )	=> "center",
			),
			"description"	=> __( 'Your button alignment', 'vcex' ),
		),
		array(
			"type"			=> "dropdown",
			"heading"		=> __( "Button Color", 'vcex' ),
			"param_name"	=> "color",
			"value"			=> array(
				__( "Black", "vcex")	=> "black",
				__( "Blue", "vcex" )	=> "blue",
				__( "Brown", "vcex" )	=> "brown",
				__( "Grey", "vcex" )	=> "grey",
				__( "Green", "vcex" )	=> "green",
				__( "Gold", "vcex" )	=> "gold",
				__( "Orange", "vcex" )	=> "orange",
				__( "Pink", "vcex" )	=> "pink",
				__( "Purple", "vcex" )	=> "purple",
				__( "Red", "vcex" ) 	=> "red",
				__( "Rosy", "vcex" )	=> "rosy",
				__( "Teal", "vcex" )	=> "teal",
				__( "White", "vcex")	=> "white",
			),
			"description"	=> __( "Select a color for this button. Note: Custom colors aren't supported for several reasons.", 'vcex' ),
		),
		array(
			"type"			=> "dropdown",
			"class"			=> "",
			"heading"		=> __( "Button Size", 'vcex' ),
			"param_name"	=> "size",
			"value"			=> array(
				__( "Small", "vcex")	=> "small",
				__( "Medium", "vcex" )	=> "medium",
				__( "Large", "vcex" )	=> "large",
			),
			"description"	=> __( "Your preferred button size. For more specific sizing you can alter the font size below.", 'vcex' ),
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __( "Custom Font Size", 'vcex' ),
			"param_name"	=> "font_size",
			"value"			=> "",
			"description"	=> __('Your button font size. Don\'t forget to enter em or px.','vcex'),
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __( "Custom Font Weight", 'vcex' ),
			"param_name"	=> "font_weight",
			"value"			=> "",
			"description"	=> __( "Your button font weight (100,200,300,400,600,700,900).", 'vcex' ),
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __( "Border Radius", 'vcex' ),
			"param_name"	=> "border_radius",
			"value"			=> "",
			"description"	=> __( 'Custom border radius. This gives your button "roundedness".', 'vcex' ),
		),
		array(
			"type"			=> "dropdown",
			"class"			=> "",
			"heading"		=> __( "Link Target", 'vcex' ),
			"param_name"	=> "target",
			"value"			=> array(
				__( "Self", "vcex")		=> "self",
				__( "Blank", "vcex" )	=> "blank",
			),
			"description"	=> __( 'Your link target. Choose self to open the link in the same browser tab and blank to open in a new tab.', 'vcex' ),
		),
		array(
			"type"			=> "dropdown",
			"class"			=> "",
			"heading"		=> __( "Link Rel", 'vcex' ),
			"param_name"	=> "rel",
			"value"			=> array(
				__( "None", "vcex")		=> "none",
				__( "Nofollow", "vcex" )	=> "nofollow",
			),
			"description"	=> __( 'Select a rel attribute for your link.', 'vcex' ),
		),
		array(
			"type"			=> "dropdown",
			"class"			=> "",
			"heading"		=> __( "Icon Left", 'vcex' ),
			"param_name"	=> "icon_left",
			"description"	=> sprintf( __( 'Icon to the left of your button text. See all the icons at %s', 'vcex' ), '<a href="http://fortawesome.github.io/Font-Awesome/icons/" target="_blank">FontAwesome</a>' ),
			"value"			=> vcex_font_icons_array(),
		),
		array(
			"type"			=> "dropdown",
			"class"			=> "",
			"heading"		=> __( "Icon Right", 'vcex' ),
			"param_name"	=> "icon_right",
			"description"	=> sprintf( __( 'Icon to the right of your button text. See all the icons at %s', 'vcex' ), '<a href="http://fortawesome.github.io/Font-Awesome/icons/" target="_blank">FontAwesome</a>' ),
			"value"			=> vcex_font_icons_array(),
		),
	)
) );
?>